<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Incubadora de Empresas de la Universidad Nacional de San Martín - UNSM">
    <meta name="keywords" content="UNSM, Incubadora de Empresas, Universidad San Martín, Emprendimiento">
    <meta name="author" content="Universidad Nacional de San Martín">
    <meta name="robots" content="index, follow">
    <meta name="theme-color" content="#359444">

    <title>Incubadora de Empresas - UNSM</title>

    <!-- Favicon -->
    <link rel="icon" type="image/png" href="../../../imagenes/escudo unsm.png" sizes="48x48">

    <!-- Stylesheet Principal -->
    <link rel="stylesheet" href="../../../css/style.css">
    <!-- Stylesheet Incubadora de Empresas -->
    <link rel="stylesheet" href="css/styleIncubadora.css?v=1.0">
</head>
<body>
    <!-- Header Superior -->
    <header class="top-header" role="banner">
        <div class="top-header-content">
            <nav class="social-icons" aria-label="Redes sociales">
                <a href="https://www.facebook.com/unsmperu" target="_blank" rel="noopener noreferrer" title="Síguenos en Facebook" aria-label="Página oficial de Facebook de la UNSM">
                    <img src="../../../imagenes/redes/logo facebook.png" alt="Facebook" width="36" height="36">
                </a>
                <a href="https://www.instagram.com/unsmperu?utm_source=ig_web_button_share_sheet&igsh=ZDNlZDc0MzIxNw==" target="_blank" rel="noopener noreferrer" title="Síguenos en Instagram" aria-label="Perfil oficial de Instagram de la UNSM">
                    <img src="../../../imagenes/redes/logo instagram.png" alt="Instagram" width="36" height="36">
                </a>
                <a href="https://youtube.com/@unsmperu?si=Lu9kVK7VlDX3qkj6" target="_blank" rel="noopener noreferrer" title="Visita nuestro canal de YouTube" aria-label="Canal oficial de YouTube de la UNSM">
                    <img src="../../../imagenes/redes/logo yt.png" alt="YouTube" width="36" height="36">
                </a>
                <a href="https://x.com/unsmperu" target="_blank" rel="noopener noreferrer" title="Síguenos en X (Twitter)" aria-label="Cuenta oficial de X de la UNSM">
                    <img src="../../../imagenes/redes/logo x.png" alt="X (Twitter)" width="36" height="36">
                </a>
                <a href="https://www.tiktok.com/@campus.unsm?is_from_webapp=1&sender_device=pc" target="_blank" rel="noopener noreferrer" title="Síguenos en TikTok" aria-label="Perfil oficial de TikTok de la UNSM">
                    <img src="../../../imagenes/redes/logo tiktok.png" alt="TikTok" width="36" height="36">
                </a>
            </nav>
            <div class="contact-info">
                <span>
                    <img src="../../../imagenes/logo telefono.png" alt="Teléfono" class="contact-icon" width="18" height="18">
                    <span>(+51) (042) 48 0159</span>
                </span>
                <span>
                    <img src="../../../imagenes/logo correo.png" alt="Correo" class="contact-icon" width="18" height="18">
                    <span>informes@unsm.edu.pe</span>
                </span>
            </div>
        </div>
    </header>

    <!-- Header Principal -->
    <header class="main-header">
        <div class="main-header-content">
            <div class="logo">
                <a href="../../../" aria-label="Ir a la página principal de UNSM">
                    <img src="../../../imagenes/logo UNSM.png" alt="Logo de la Universidad Nacional de San Martín" width="auto" height="70">
                </a>
            </div>

            <!-- Botón Hamburguesa para móvil -->
            <button class="mobile-menu-toggle" aria-label="Abrir menú de navegación" aria-expanded="false" aria-controls="main-navigation">
                <span aria-hidden="true"></span>
                <span aria-hidden="true"></span>
                <span aria-hidden="true"></span>
            </button>

            <nav class="main-nav" id="main-navigation" aria-label="Navegación principal">
                <div class="mobile-nav-logo">
                    <img src="../../../imagenes/logo UNSM.png" alt="Logo UNSM" width="auto" height="65">
                </div>

                <ul class="nav-menu">
                    <li class="dropdown">
                        <a href="../../../#nosotros" aria-haspopup="true" aria-expanded="false">NOSOTROS</a>
                        <ul class="dropdown-menu" aria-label="Menú Nosotros">
                            <li><a href="../../../nosotros/autoridades/indexAuto.php">Autoridades</a></li>
                            <li><a href="../../../nosotros/historia/historia.php">Historia de la Universidad</a></li>
                            <li><a href="../../../nosotros/mision/indexMision.php">Nuestra Misión y Visión</a></li>
                            <li><a href="../../../nosotros/objetivos/objeIndex.php">Objetivos</a></li>
                            <li><a href="../../../nosotros/onigrama/indexOni.php">Organigrama</a></li>
                            <li><a href="../../../nosotros/himno/indexHimno.php">Himno</a></li>
                            <li><a href="../../../nosotros/directorioInstucional/indexDirec.php">Directorio Institucional</a></li>
                            <li><a href="../../../nosotros/calendarioAcade/indexCale.php">Calendario Académico</a></li>
                        </ul>
                    </li>
                    <li class="dropdown dropdown-wide">
                        <a href="../../../#oficinas" aria-haspopup="true" aria-expanded="false">OFICINAS</a>
                        <ul class="dropdown-menu dropdown-columns" aria-label="Menú Oficinas">
                            <div class="dropdown-column">
                                <li class="dropdown-header">Oficinas Administrativas</li>
                                <li><a href="../../../oficinas/rectorado/indexRecto.php">Rectorado</a></li>
                                <li><a href="../../../oficinas/vicerrectorado academico/indexVicerec.php">Vicerrectorado Académico</a></li>
                                <li><a href="../../../oficinas/vicerrectorado de investigacion/indexViceRecAca.php">Vicerrectorado de Investigación</a></li>
                                <li><a href="../../../oficinas/secretaria general/indexSecreGene.php">Secretaría General</a></li>
                                <li><a href="../../../oficinas/planeamiento y presupuesto/indexPlanea.php">Planeamiento y Presupuesto</a></li>
                                <li><a href="../../../oficinas/seguridad y salud ocupacional/indexSeguri.php">Seguridad y Salud Ocupacional</a></li>
                                <li><a href="../../../oficinas/comunicacion y imagen institucional/indexImagen.php">Comunicación e Imagen Institucional</a></li>
                                <li><a href="../../../oficinas/Cooperacion y Relaciones Internacionales/indexCoopera.php">Cooperación y Relaciones Internacionales</a></li>
                                <li><a href="../../../oficinas/Organo de Control Institucional/indexOrgaConIns.php">Órgano de Control Institucional</a></li>
                                <li><a href="../../../oficinas/Ejecutora de Inversiones/indexEjec.php">Ejecutora de Inversiones</a></li>
                                <li><a href="../../../oficinas/Asesoria Juridica/indexAseJuri.php">Asesoría Jurídica</a></li>
                                <li><a href="../../../oficinas/Grados y Titulos/indexGrados.php">Grados y Títulos</a></li>
                            </div>
                            <div class="dropdown-column">
                                <li class="dropdown-header">Oficinas Académicas</li>
                                <li><a href="../OFICINA DE ADMISION/indexOfiAdmin.php">Oficina de Admisión</a></li>
                                <li><a href="../ASUNTOS ACADEMICOS/indexAsunAca.php">Asuntos Académicos</a></li>
                                <li><a href="../Seguimiento al Egresado e Insercion Laboral/indexSegui.php">Seguimiento al Egresado e Inserción Laboral</a></li>
                                <li><a href="../TECNOLOGIAS DE LA INFORMACION/indexOTI.php">Tecnologías de la Información</a></li>
                                <li><a href="./">Incubadora de Empresas</a></li>
                                <li><a href="../../../#fondo-editorial">Fondo Editorial</a></li>
                                <li><a href="../../../#comite-electoral">Comité Electoral Universitario</a></li>
                                <li><a href="../../../#innovacion">Innovación y Transferencia Tecnológica</a></li>
                                <li><a href="../../../#produccion">Producción de Bienes y Servicios</a></li>
                                <li><a href="../../../#responsabilidad">Responsabilidad Social Universitaria</a></li>
                                <li><a href="../../../#servicios-generales">Servicios Generales</a></li>
                                <li><a href="../../../#bienestar">Bienestar Universitario</a></li>
                                <li><a href="../../../#defensoria">Defensoría Universitaria</a></li>
                                <li><a href="../../../#calidad">Gestión de la Calidad</a></li>
                            </div>
                        </ul>
                    </li>
                    <li><a href="../../../#admision">ADMISIÓN</a></li>
                    <li><a href="../../../#cpu">CPU</a></li>
                    <li class="dropdown dropdown-facultades">
                        <a href="../../../#facultades" aria-haspopup="true" aria-expanded="false">FACULTADES</a>
                        <ul class="dropdown-menu" aria-label="Menú Facultades">
                            <li class="has-submenu">
                                <a href="../../../#ciencias-agrarias" aria-haspopup="true" aria-expanded="false">Ciencias Agrarias</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias Agrarias">
                                    <li><a href="../../../#agronomia">Agronomía</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../#ciencias-salud" aria-haspopup="true" aria-expanded="false">Ciencias de la Salud</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias de la Salud">
                                    <li><a href="../../../#obstetricia">Obstetricia</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../#medicina-veterinaria" aria-haspopup="true" aria-expanded="false">Medicina Veterinaria</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Medicina Veterinaria">
                                    <li><a href="../../../#medicina-veterinaria-carrera">Medicina Veterinaria</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../#ingenieria-agroindustrial" aria-haspopup="true" aria-expanded="false">Ingeniería Agroindustrial</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingeniería Agroindustrial">
                                    <li><a href="../../../#ing-agroindustrial">Ingeniería Agroindustrial</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../#ingenieria-civil" aria-haspopup="true" aria-expanded="false">Ingeniería Civil y Arquitectura</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingeniería Civil y Arquitectura">
                                    <li><a href="../../../#arquitectura">Arquitectura</a></li>
                                    <li><a href="../../../#ingenieria-civil-carrera">Ingeniería Civil</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../#ingenieria-sistemas" aria-haspopup="true" aria-expanded="false">Ingeniería de Sistemas e Informática</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingeniería de Sistemas">
                                    <li><a href="../../../#ing-sistemas">Ingeniería de Sistemas e Informática</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../#ecologia" aria-haspopup="true" aria-expanded="false">Ecología</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ecología">
                                    <li><a href="../../../#ing-ambiental">Ingeniería Ambiental</a></li>
                                    <li><a href="../../../#ing-sanitaria">Ingeniería Sanitaria</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../#derecho" aria-haspopup="true" aria-expanded="false">Derecho y Ciencias Políticas</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Derecho">
                                    <li><a href="../../../#derecho-carrera">Derecho</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../#medicina-humana" aria-haspopup="true" aria-expanded="false">Medicina Humana</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Medicina Humana">
                                    <li><a href="../../../#medicina-humana-carrera">Medicina Humana</a></li>
                                    <li><a href="../../../#enfermeria">Enfermería</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../#ciencias-economicas" aria-haspopup="true" aria-expanded="false">Ciencias Económicas</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias Económicas">
                                    <li><a href="../../../#administracion">Administración</a></li>
                                    <li><a href="../../../#contabilidad">Contabilidad</a></li>
                                    <li><a href="../../../#economia">Economía</a></li>
                                    <li><a href="../../../#turismo">Turismo</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../#educacion" aria-haspopup="true" aria-expanded="false">Educación y Humanidades</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Educación">
                                    <li><a href="../../../#educacion-inicial">Educación Inicial</a></li>
                                    <li><a href="../../../#educacion-primaria">Educación Primaria</a></li>
                                    <li><a href="../../../#educacion-secundaria">Educación Secundaria</a></li>
                                    <li><a href="../../../#idiomas">Idiomas</a></li>
                                    <li>
                                        <a href="../../../#psicologia">
                                            Psicología
                                            <span class="badge-nuevo">Nuevo</span>
                                        </a>
                                    </li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                    <li><a href="../../../#posgrado">POSGRADO</a></li>
                    <li class="dropdown">
                        <a href="../../../#transparencia" aria-haspopup="true" aria-expanded="false">TRANSPARENCIA</a>
                        <ul class="dropdown-menu" aria-label="Menú Transparencia">
                            <li><a href="../../../#licenciamiento">Licenciamiento</a></li>
                            <li><a href="../../../#institucional">Institucional Ley 30220</a></li>
                            <li><a href="../../../#estandar">Estándar Ley 27806</a></li>
                        </ul>
                    </li>
                </ul>

                <div class="mobile-nav-gob-logos">
                    <a href="https://www.gob.pe/unsm" target="_blank" rel="noopener noreferrer" aria-label="Portal de Transparencia de la UNSM">
                        <img src="../../../imagenes/logo portal de trans.png" alt="Portal de Transparencia" width="auto" height="35">
                    </a>
                    <a href="https://www.gob.pe" target="_blank" rel="noopener noreferrer" aria-label="Portal del Gobierno del Perú">
                        <img src="../../../imagenes/logo gobPe.png" alt="Gobierno del Perú" width="auto" height="35">
                    </a>
                </div>
            </nav>

            <div class="gob-logos">
                <a href="https://www.gob.pe/unsm" target="_blank" rel="noopener noreferrer" aria-label="Portal de Transparencia">
                    <img src="../../../imagenes/logo portal de trans.png" alt="Portal de Transparencia" class="portal-trans-logo" width="auto" height="32">
                </a>
                <a href="https://www.gob.pe" target="_blank" rel="noopener noreferrer" aria-label="Gobierno del Perú">
                    <img src="../../../imagenes/logo gobPe.png" alt="Gobierno del Perú" class="gob-logo" width="auto" height="30">
                </a>
            </div>
        </div>
    </header>

    <!-- Banner Incubadora de Empresas -->
    <section class="incubadora-banner">
        <div class="banner-container">
            <h1>INCUBADORA DE EMPRESAS</h1>
            <div class="banner-contact">
                <p><strong>Local Central: Jr. Maynas N° 177, Tarapoto, Perú</strong></p>
                <p>incubadoradeempresas@unsm.edu.pe</p>
            </div>
        </div>
    </section>

    <!-- Contenido Principal -->
    <main class="incubadora-main">
        <div class="incubadora-container">
            <!-- Sidebar con tabs -->
            <aside class="incubadora-sidebar">
                <nav class="tabs-menu">
                    <button class="tab-button active" data-tab="funciones">
                        <span class="tab-icon">?</span>
                        <span class="tab-text">FUNCIONES</span>
                    </button>
                    <button class="tab-button" data-tab="mision">
                        <span class="tab-icon">🎯</span>
                        <span class="tab-text">MISIÓN</span>
                    </button>
                    <button class="tab-button" data-tab="vision">
                        <span class="tab-icon">👁</span>
                        <span class="tab-text">VISIÓN</span>
                    </button>
                    <button class="tab-button" data-tab="personal">
                        <span class="tab-icon">👤</span>
                        <span class="tab-text">PERSONAL</span>
                    </button>
                    <button class="tab-button" data-tab="documentos">
                        <span class="tab-icon">📃</span>
                        <span class="tab-text">DOCUMENTOS</span>
                    </button>
                    <button class="tab-button" data-tab="eventos">
                        <span class="tab-icon">📅</span>
                        <span class="tab-text">EVENTOS</span>
                    </button>
                    <button class="tab-button" data-tab="galeria">
                        <span class="tab-icon">📷</span>
                        <span class="tab-text">GALERÍA</span>
                    </button>
                </nav>
            </aside>

            <!-- Contenido principal -->
            <div class="incubadora-content">
                <!-- Tab de Funciones -->
                <div class="tab-content active" id="funciones">
                    <div class="content-wrapper">
                        <div class="funciones-section">
                            <h2>FUNCIONES DEL PERSONAL</h2>
                            <ul class="funciones-list">
                                <li><strong>Director de la Dirección de Incubadora de Empresas:</strong> La persona encargada de la supervisión general de las actividades de la incubadora, estableciendo alianzas estratégicas y la gestión de recursos.</li>
                                <li><strong>Coordinadora de proyectos:</strong> Encargada de la planificación y seguimiento de las iniciativas de los emprendedores incubados, asegurando que los proyectos se alineen con los objetivos y plazos establecidos.</li>
                                <li><strong>Equipo administrativo y de soporte:</strong> Personal encargado de la gestión operativa, logística y financiera de la incubadora.</li>
                            </ul>
                        </div>
                    </div>

                    <!-- Widget de Últimas Noticias -->
                    <aside class="noticias-widget">
                        <h3>Últimas Noticias</h3>
                        <div class="noticias-container">
                            <p class="no-events">No hay nuevos eventos.</p>
                            <div class="calendario-actions">
                                <button class="btn-add">Añadir</button>
                                <a href="#" class="btn-calendar">Ver Calendario ▸</a>
                            </div>
                        </div>
                    </aside>
                </div>

                <!-- Tab de Misión -->
                <div class="tab-content" id="mision">
                    <div class="content-wrapper">
                        <h2>MISIÓN</h2>
                        <p>Fomentar y apoyar el desarrollo de emprendimientos innovadores y sostenibles en la región San Martín, brindando a estudiantes, egresados y la comunidad en general las herramientas, conocimientos y recursos necesarios para transformar ideas de negocio en empresas exitosas que contribuyan al desarrollo económico y social de la región.</p>
                    </div>
                </div>

                <!-- Tab de Visión -->
                <div class="tab-content" id="vision">
                    <div class="content-wrapper">
                        <h2>VISIÓN</h2>
                        <p>Ser reconocida como la principal incubadora de empresas de la región San Martín, destacándose por su capacidad de generar emprendimientos innovadores, competitivos y sostenibles que impulsen el desarrollo económico local y regional, posicionando a la UNSM como un referente en la formación de emprendedores y en la promoción de una cultura empresarial de excelencia.</p>
                    </div>
                </div>

                <!-- Tab de Personal -->
                <div class="tab-content" id="personal">
                    <div class="content-wrapper">
                        <h2>PERSONAL</h2>
                        <p>La Incubadora de Empresas de la UNSM cuenta con un equipo multidisciplinario de profesionales comprometidos con el fomento del emprendimiento y la innovación.</p>
                        <ul class="funciones-list">
                            <li><strong>Director de Incubadora:</strong> Líder estratégico de todas las operaciones</li>
                            <li><strong>Coordinadores de Proyectos:</strong> Gestores del desarrollo de emprendimientos</li>
                            <li><strong>Mentores Especializados:</strong> Expertos en diferentes áreas empresariales</li>
                            <li><strong>Equipo de Soporte:</strong> Personal administrativo y técnico</li>
                        </ul>
                    </div>
                </div>

                <!-- Tab de Documentos -->
                <div class="tab-content" id="documentos">
                    <div class="content-wrapper">
                        <h2>DOCUMENTOS</h2>
                        <p>Aquí encontrarás los principales documentos normativos, formularios y guías para emprendedores:</p>
                        <ul class="funciones-list">
                            <li>Reglamento de la Incubadora de Empresas</li>
                            <li>Manual de procedimientos para emprendedores</li>
                            <li>Formularios de inscripción</li>
                            <li>Guías de desarrollo de planes de negocio</li>
                            <li>Convenios y alianzas estratégicas</li>
                        </ul>
                    </div>
                </div>

                <!-- Tab de Eventos -->
                <div class="tab-content" id="eventos">
                    <div class="content-wrapper">
                        <h2>EVENTOS</h2>
                        <p>La Incubadora de Empresas organiza regularmente diversos eventos para promover el emprendimiento:</p>
                        <ul class="funciones-list">
                            <li>Talleres de capacitación empresarial</li>
                            <li>Concursos de ideas de negocio</li>
                            <li>Ferias de emprendimiento</li>
                            <li>Conferencias con empresarios exitosos</li>
                            <li>Sesiones de networking</li>
                        </ul>
                    </div>
                </div>

                <!-- Tab de Galería -->
                <div class="tab-content" id="galeria">
                    <div class="content-wrapper">
                        <h2>GALERÍA</h2>
                        <p>Conoce las instalaciones de nuestra incubadora y los momentos más importantes de nuestros emprendedores.</p>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <!-- Footer -->
    <footer role="contentinfo">
        <div class="footer-content">
            <section class="footer-section">
                <div class="footer-logo-section">
                    <img src="../../../imagenes/escudo unsm.png" alt="Escudo oficial de la UNSM" class="footer-logo" width="60" height="auto">
                    <h3 class="footer-title">UNSM</h3>
                </div>
                <p class="footer-description">Centro Superior de Estudios autónomo y de carácter estatal, comprometido con la formación de profesionales humanistas y competitivos, con responsabilidad social y comprometidos con el desarrollo local, regional y nacional.</p>
                <address>
                    <p>Jr. Maynas N° 177 - Morales</p>
                    <p>Tarapoto - San Martín - Perú</p>
                    <p>Central Telefónica: <span>(+51) (042) 48 0159</span></p>
                    <p>Email: <span>informes@unsm.edu.pe</span></p>
                </address>
            </section>

            <nav class="footer-section" aria-labelledby="footer-links-title">
                <h3 id="footer-links-title" class="footer-title">Enlaces Rápidos</h3>
                <ul class="footer-links">
                    <li><a href="../../../#admision">Admisión</a></li>
                    <li><a href="../../../#facultades">Facultades</a></li>
                    <li><a href="../../../#posgrado">Posgrado</a></li>
                    <li><a href="../../../#investigacion">Investigación</a></li>
                </ul>
            </nav>

            <nav class="footer-section" aria-labelledby="footer-services-title">
                <h3 id="footer-services-title" class="footer-title">Servicios</h3>
                <ul class="footer-links">
                    <li><a href="../../../#biblioteca">Biblioteca Virtual</a></li>
                    <li><a href="../../../#campus-virtual">Campus Virtual</a></li>
                    <li><a href="../../../#repositorio">Repositorio Institucional</a></li>
                    <li><a href="../../../#transparencia">Portal de Transparencia</a></li>
                    <li><a href="../../../#libro-reclamaciones">Libro de Reclamaciones</a></li>
                    <li><a href="../../../contacto/indexContac.php">Enviar Mensaje</a></li>
                </ul>
            </nav>

            <section class="footer-section footer-facebook" aria-labelledby="footer-facebook-title">
                <h3 id="footer-facebook-title" class="footer-title">Facebook UNSM</h3>
                <!-- Plugin de Facebook -->
                <?php include 'plugin/meta.html'; ?>
            </section>
        </div>

        <div class="footer-bottom">
            <div class="footer-bottom-content">
                <p>&copy; 2025 Universidad Nacional de San Martín. Todos los derechos reservados.</p>
                <div class="footer-social-bottom">
                    <span class="footer-social-title">Síguenos</span>
                    <nav class="footer-social" aria-label="Redes sociales de la UNSM">
                        <a href="https://www.facebook.com/unsmperu" target="_blank" rel="noopener noreferrer" aria-label="Facebook UNSM">
                            <img src="../../../imagenes/redes/logo facebook.png" alt="Facebook" width="22" height="22">
                        </a>
                        <a href="https://www.instagram.com/unsmperu?utm_source=ig_web_button_share_sheet&igsh=ZDNlZDc0MzIxNw==" target="_blank" rel="noopener noreferrer" aria-label="Instagram UNSM">
                            <img src="../../../imagenes/redes/logo instagram.png" alt="Instagram" width="22" height="22">
                        </a>
                        <a href="https://youtube.com/@unsmperu?si=Lu9kVK7VlDX3qkj6" target="_blank" rel="noopener noreferrer" aria-label="YouTube UNSM">
                            <img src="../../../imagenes/redes/logo yt.png" alt="YouTube" width="22" height="22">
                        </a>
                        <a href="https://www.tiktok.com/@campus.unsm?is_from_webapp=1&sender_device=pc" target="_blank" rel="noopener noreferrer" aria-label="TikTok UNSM">
                            <img src="../../../imagenes/redes/logo tiktok.png" alt="TikTok" width="22" height="22">
                        </a>
                        <a href="https://x.com/unsmperu" target="_blank" rel="noopener noreferrer" aria-label="X (Twitter) UNSM">
                            <img src="../../../imagenes/redes/logo x.png" alt="X" width="22" height="22">
                        </a>
                    </nav>
                </div>
            </div>
        </div>
    </footer>

    <script src="../../../js/script.js" defer></script>
    <script src="js/scriptIncubadora.js?v=1.0" defer></script>
    <div id="fb-root"></div>
    <script async defer crossorigin="anonymous" src="https://connect.facebook.net/es_LA/sdk.js#xfbml=1&version=v18.0"></script>
</body>
</html>
